<?php

namespace UtillzCore\Inc\Src\Admin\Columns;

use \UtillzCore\Inc\Src\Traits\Singleton;

class Collection {

    use Singleton;

    function __construct() {

        add_filter( 'manage_edit-ulz_collection_columns', [ $this, 'columns' ] );
        add_action( 'manage_ulz_collection_posts_custom_column', [ $this, 'custom_columns' ], 10, 2 );
        add_filter( 'manage_edit-ulz_collection_sortable_columns', [ $this, 'sortable_columns' ] );

    }

    public function columns( $columns ) {

        if ( ! is_array( $columns ) ) {
            $columns = [];
        }

        unset(
            $columns['title'],
            $columns['author'],
            $columns['date']
        );

        $columns['ulz_image'] = '&nbsp;';
        $columns['ulz_title'] = esc_html__( 'Title', 'utillz-core' );
        $columns['ulz_date'] = esc_html__( 'Date', 'utillz-core' );

        return $columns;

    }

    public function custom_columns( $column, $post_id ) {

        global $post;

        $collection = new \UtillzCore\Inc\Src\Collection\Collection();
        $gallery = $collection->get_collection_gallery( 1, 'thumbnail' );

        switch ( $column ) {

            case 'ulz_image': ?>

                <div class="ulz-column-image">
                    <?php if( has_post_thumbnail() ): ?>
                        <img src="<?php echo get_the_post_thumbnail_url( $post->ID, 'thumbnail' ); ?>" alt="">
                    <?php elseif( $gallery ): ?>
                        <?php foreach( $gallery as $image ): ?>
                            <img src="<?php echo esc_url( $image ); ?>" alt="">
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="ulz-dummy-image">
                            <?php echo utillz_core()->icon->get( 'perm_media', 'material-icons' ); ?>
                        </div>
                    <?php endif; ?>
                <?php

                break;

            case 'ulz_title':

                $entry_title = sprintf( ' #%s %s', get_the_ID(), get_the_title() );
                $entry_type = Ucore()->get_entry_type( Ucore()->get( 'ulz_entry_type' ) );

                echo '<div class="ulz-edit-title">';
                    echo '<a href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&action=edit' ) ) . '" class="tips" data-tip="' . sprintf( esc_html__( 'ID: %d', 'utillz-core' ), intval( $post_id ) ) . '">' . esc_html( $entry_title ) . '</a>';
                echo '</div>';

                break;

            case 'ulz_date':

                $post_status = get_post_status_object( get_post_status( $post->ID ) );

                echo '<div class="ulz-posted">';
                echo $post_status->label;
                echo ( empty( $post->post_author ) ? esc_html__( ', by a guest', 'utillz-core' ) : sprintf( esc_html__( ', by %s', 'utillz-core' ), '<a href="' . esc_url( add_query_arg( 'author', $post->post_author ) ) . '">' . esc_html( get_the_author() ) . '</a>' ) );
                echo '<strong>' . esc_html( date_i18n( sprintf( '%s %s', get_option( 'date_format' ), get_option( 'time_format' ) ), strtotime( $post->post_date ) ) ) . '</strong>';
                echo '</div>';
                break;

        }
    }

    public function sortable_columns( $columns ) {

        $custom = [
            'ulz_title' => 'title',
            'ulz_date' => 'date',
        ];

        return wp_parse_args( $custom, $columns );

    }

}
