<?php

namespace UtillzCore\Inc\Src\Admin\Columns;

use \UtillzCore\Inc\Src\Traits\Singleton;

class Listing_Type {

    use Singleton;

    function __construct() {

        add_filter( 'manage_edit-ulz_listing_type_columns', [ $this, 'columns' ] );
        add_action( 'manage_ulz_listing_type_posts_custom_column', [ $this, 'custom_columns' ], 10, 2 );
        add_filter( 'manage_edit-ulz_listing_type_sortable_columns', [ $this, 'sortable_columns' ] );

    }

    public function columns( $columns ) {

        if ( ! is_array( $columns ) ) {
            $columns = [];
        }

        unset(
            $columns['title'],
            $columns['date'],
            $columns['author'],
            $columns['comments']
        );

        $columns['ulz_image'] = '&nbsp;';
        $columns['ulz_title'] = esc_html__( 'Title', 'utillz-core' );
        $columns['ulz_posted'] = esc_html__( 'Posted', 'utillz-core' );
        $columns['ulz_actions'] = esc_html__( 'Actions', 'utillz-core' );

        return $columns;

    }

    public function custom_columns( $column, $post_id ) {

        global $post;

        switch ( $column ) {

            case 'ulz_image': ?>

                <div class="ulz-column-image">
                    <?php if( has_post_thumbnail() ): ?>
                        <?php the_post_thumbnail('thumbnail'); ?>
                    <?php else: ?>
                        <div class="ulz-dummy-image">
                            <?php echo utillz_core()->icon->get( Ucore()->get('ulz_icon__icon'), Ucore()->get('ulz_icon__set') ); ?>
                        </div>
                    <?php endif; ?>
                </div><?php

                break;

            case 'ulz_title':

                $statuses = get_post_statuses();
                $post_status = get_post_status();

                echo '<div class="ulz-edit-title">';
                    echo '<a href="' . esc_url( admin_url( 'post.php?post=' . $post_id . '&action=edit' ) ) . '" class="tips" data-tip="' . sprintf( esc_html__( 'ID: %d', 'utillz-core' ), intval( $post_id ) ) . '">' . esc_html( $post->post_title ) . '</a>';
                    echo '<div class="ulz-edit-type"><span>' . ( isset( $statuses[ $post_status ] ) ? $statuses[ $post_status ] : '' ) . '</span></div>';
                echo '</div>';

                break;

            case 'ulz_posted':

                echo '<div class="ulz-posted">';
                echo '<strong>' . esc_html( date_i18n( get_option( 'date_format' ), strtotime( $post->post_date ) ) ) . '</strong><span>';
                echo ( empty( $post->post_author ) ? esc_html__( 'by a guest', 'utillz-core' ) : sprintf( esc_html__( 'by %s', 'utillz-core' ), '<a href="' . esc_url( add_query_arg( 'author', $post->post_author ) ) . '">' . esc_html( get_the_author() ) . '</a>' ) ) . '</span>';
                echo '</div>';
                break;

            case 'ulz_actions':

                echo '<div class="ulz-actions">';
                $admin_actions = apply_filters( 'admin_edit_listing_actions', [], $post );

                if ( in_array( $post->post_status, [ 'pending', 'pending_payment' ], true ) && current_user_can( 'publish_post', $post_id ) ) {
                    $admin_actions['approve'] = [
                        'action' => 'approve',
                        'name' => esc_html__( 'Approve', 'utillz-core' ),
                        'url' => wp_nonce_url( add_query_arg( 'approve_listing', $post_id ), 'approve_listing' ),
                        'icon' => 'fas fa-check',
                    ];
                }

                if( 'trash' !== $post->post_status ) {
                    if( current_user_can( 'edit_post', $post_id ) ) {
                        $admin_actions['edit'] = [
                            'action' => 'edit',
                            'name' => esc_html__( 'Edit', 'utillz-core' ),
                            'url' => get_edit_post_link( $post_id ),
                            'icon' => 'fas fa-pen',
                        ];
                    }
                    if( current_user_can( 'edit_post', $post_id ) ) {
                        $admin_actions['duplicate'] = [
                            'action' => 'duplicate',
                            'name' => esc_html__( 'Duplicate', 'utillz-core' ),
                            'url' => add_query_arg( ['duplicate' => '' ], get_edit_post_link( $post_id ) ),
                            'icon' => 'fas fa-clone',
                        ];
                    }
                    if( current_user_can( 'delete_post', $post_id ) ) {
                        $admin_actions['delete'] = [
                            'action' => 'delete',
                            'name' => esc_html__( 'Delete', 'utillz-core' ),
                            'url' => get_delete_post_link( $post_id ),
                            'icon' => 'fas fa-trash-alt',
                        ];
                    }
                }

                $admin_actions = apply_filters( 'ulz_admin_actions', $admin_actions, $post );

                foreach ( $admin_actions as $action ) {
                    if ( is_array( $action ) ) {
                        printf( '<a class="button button-icon tips icon-%1$s" href="%2$s" data-tip="%3$s"><i class="%4$s"></i></a>', esc_attr( $action['action'] ), esc_url( $action['url'] ), esc_attr( $action['name'] ), esc_html( $action['icon'] ) );
                    }else{
                        echo wp_kses_post( str_replace( 'class="', 'class="button ', $action ) );
                    }
                }

                echo '</div>';

                break;

        }
    }

    public function sortable_columns( $columns ) {

        $custom = [
            'ulz_posted'                     => 'date',
            'ulz_title'                      => 'title',
            'taxonomy-ulz_listing_category'  => 'title',
            'taxonomy-ulz_listing_region'    => 'title',
            'taxonomy-ulz_listing_tag'       => 'title',
            'ulz_location'                   => 'ulz_location',
            'ulz_expires'                    => 'ulz_expires',
        ];

        return wp_parse_args( $custom, $columns );

    }

}
