<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\User;
use \UtillzCore\Inc\Src\Listing\Listing;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Account_Entry extends Endpoint {

	public $action = 'utillz-entry-edit';

    public function action() {

		$request = Request::instance();

		$entry_id = (int) $request->get('id');
		$entry_type = Ucore()->get( 'ulz_entry_type', $entry_id );

		if( ! $entry_id ) {
			return;
		}

		$current_user = get_current_user_id();
		$user = new User( Ucore()->get('ulz_request_user_id', $entry_id) );
		$user_owner_id = get_post_field( 'post_author', $entry_id );
		$listing = new Listing( Ucore()->get( 'ulz_listing', $entry_id ) );

		// bail if the user doesn't participate in the entry
		if( ! ( $current_user == $user->id || $current_user == $user_owner_id ) ) {
			return;
		}

		wp_send_json([
			'success' => true,
			'html' => Ucore()->get_template('modals/entry-edit/append')
		]);

	}

}
