<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Dynamic_Explore extends Endpoint {

	public $action = 'utillz-dynamic-explore';

    public function action() {

		global $ulz_explore;

		if( $post_id = $ulz_explore->request->get('post_id') ) {
			global $post;
			$post = get_post( $post_id, OBJECT );
			setup_postdata( $post );
		}

		$output = [
			'success' 		=> true,
			'type' 			=> $ulz_explore->get_explore_type(),
			'columns' 		=> $ulz_explore->get_explore_columns(),
			'title' 		=> Ucore()->get_template('explore/title'),
			'listings' 		=> Ucore()->get_template('explore/listings'),
			'filters' 		=> Ucore()->get_template('explore/filters'),
			'markers' 		=> Ucore()->get_template('explore/map/markers'),
			'infoboxes' 	=> Ucore()->get_template('explore/map/infoboxes'),
			'found_posts' 	=> $ulz_explore->type ? $ulz_explore->query()->posts->found_posts : 0,
			'post_count' 	=> $ulz_explore->type ? $ulz_explore->query()->posts->post_count : 0,
		];

		// primary search form
		if( ! $ulz_explore->request->is_empty('search_form_id') ) {
			$output['search_form'] = [
				'form_id' 	=> $ulz_explore->request->get('search_form_id'),
				'html' 		=> do_shortcode("[ulz-search-form id='{$ulz_explore->request->get('search_form_id')}']")
			];
		}

		wp_send_json( $output );

	}

}
