<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Send_Message extends Endpoint {

	public $action = 'utillz-send-message';

    public function action() {

		global $ulz_conversation;

		$request = Src\Request\Request::instance();

		// security
		if( $request->is_empty('security') || ! wp_verify_nonce( $request->get('security'), 'ajax-nonce' ) ) {
			return;
		}

		// required
		if( $request->is_empty('message') ) {
			wp_send_json([
				'success' => false,
				'error' => esc_html__( 'Please enter a message', 'utillz-core' )
			]);
		}

		$data = (object) Ucore()->sanitize( $_POST );

		/*
		 * send message
		 *
		 */
		if( ! $request->is_empty('conversation_id') ) {
			$id = (int) $request->get('conversation_id');
		}elseif( ! $request->is_empty('listing_id') ) {
			$id = (int) $request->get('listing_id');
		}elseif( ! $request->is_empty('direct_user_id') ) {
			$id = (int) $request->get('direct_user_id');
		}

		$ulz_conversation = new Src\Listing\Conversation( $id );
		$ulz_conversation->send( $_POST['message'] );

		/*
		 * notify message receiver
		 *
		 */
		$args = [
			'from_user_id' => get_current_user_id()
		];

		if( $listing_id = $request->get('listing_id') ) {
			$args['listing_id'] = (int) $listing_id;
		}

		utillz_core()->notify->distribute( 'new-message', [
	        'user_id' => $ulz_conversation->receiver_id,
			'meta' => $args
	    ]);

		wp_send_json([
			'success' => true,
			'count' => $ulz_conversation->count_messages(),
			'html' => Ucore()->get_template('modals/conversation/messages'),
		]);

	}

}
