<?php

namespace UtillzCore\Inc\Src\Admin\Http\Endpoints;

use \UtillzCore\Inc\Src\Request\Request;
use \UtillzCore\Inc\Src\Listing\Listing;

if ( ! defined('ABSPATH') ) {
	exit;
}

class Endpoint_Send_Report extends Endpoint {

	public $action = 'utillz-send-report';

    public function action() {

		$request = Request::instance();

		// security
		if ( $request->is_empty('security') || ! wp_verify_nonce( $request->get('security'), 'utillz_report_nonce' ) ) {
			return;
		}

		// required
		if( $request->is_empty('listing_id') || $request->is_empty('report_reason') ) {
			wp_send_json([
				'success' => false,
				'errors' => [
					'report_reason' => esc_html__( 'Please select a reason', 'utillz-core' )
				]
			]);
		}

		$data = (object) Ucore()->sanitize( $_POST );

		// listing
		$listing = new Listing( $data->listing_id );
		if( ! $listing->id ) {
			return;
		}

		$listing->report( $data->report_reason );

		wp_send_json([
			'success' => true
		]);

	}

}
