@include('label.index')

<div class="ulz-number-type-{{ $input_type }}" data-type="{{ $input_type }}">

    @if( $input_type == 'stepper' )

        <div class="ulz-stepper ulz--{{ $style }}">
            <input class="{{ $style == 'v1' ? 'ulz-none' : '' }}" type="number" name="{{ $id }}" value="{{ $value }}" {!! Ucore()->attrs( $number_attrs ) !!} {{ $v_model ? "v-model={$v_model}" : '' }} {!! $readonly ? 'form="fake-form-readonly"' : '' !!}>
            <div class="ulz--row">
                <div class="ulz--cell">
                    <a href="#" class="ulz-stepper-button" data-action="decrease">
                        <i class="fas fa-minus"></i>
                    </a>
                </div>
                <div class="ulz--cell ulz--cell-text ulz-flex ulz-flex-column ulz-justify-center">
                    <p class="ulz-stepper-text">{!! sprintf( $format, $value ) !!}</p>
                </div>
                <div class="ulz--cell">
                    <a href="#" class="ulz-stepper-button" data-action="increase">
                        <i class="fas fa-plus"></i>
                    </a>
                </div>
            </div>
        </div>

    @else

        @if( $input_type == 'range' )
            <p class="ulz-number-range-text">{!! sprintf( $format, $value ) !!}</p>
        @endif
        <input type="{{ $input_type }}" name="{{ $id }}" value="{{ $value }}" placeholder="{{ $placeholder }}" {!! Ucore()->attrs( $number_attrs ) !!} {{ $v_model ? "v-model={$v_model}" : '' }} {!! $readonly ? 'form="fake-form-readonly"' : '' !!}>

    @endif

</div>
