@include('label.index')

@if( $templates_num == 0 )

    <div class="ulz-notice ulz-notice-alert">
        <p>
            {{ $strings->no_modules }}
        </p>
    </div>

@else

    <div class="ulz-repeater @if( ! isset( $repeater->props->parent ) ) ulz-repeater-collect @endif">

        @if( ! isset( $repeater->props->parent ) )
            <textarea type="text" class="ulz-repeater-value ulz-none" name="{{ $id }}" {{ $v_model ? "v-model={$v_model}" : '' }}>{!! htmlspecialchars( $value ) !!}</textarea>
        @endif

        <div class="ulz-repeater-items">
            @if( is_array( $items ) )
                @foreach ( $items as $item )
                    @php
                        if( is_object( $item ) && isset( $templates[ $item->template->id ] ) ) {
                            $component->render( array_merge( (array) $item, [
                                'type' => 'repeater-item',
                                'schema' => $templates[ $item->template->id ],
                                'parent' => $repeater,
                            ]));
                        }
                    @endphp
                @endforeach
            @endif
        </div>

        <div class="ulz-repeater-select">
            <div class="ulz-select @if( $templates_num <= 1 ) ulz-none @endif">
                <select>
                    <option value="">&mdash;&nbsp;{{ $strings->select }}&nbsp;&mdash;</option>
                    @foreach ( $templates as $template_id => $template )
                        <option value="{{ $template_id }}" @if( $templates_num <= 1 ) selected="selected" @endif>{{ $template['name'] }}</option>
                    @endforeach
                </select>
            </div>
            <div class="ulz-text-center">
                <div class="ulz-repeater-action">
                    <a href="#" class="ulz-button ulz--secondary ulz--small">
                        <span>{{ $strings->add_new }}</span>
                        <?php Ucore()->preloader(); ?>
                    </a>
                </div>
            </div>
        </div>

        <input type="hidden" class="ulz-repeater-schema" value='{{ htmlspecialchars( json_encode( $templates ), ENT_QUOTES, 'UTF-8' ) }}'>

    </div>

@endif
