<div class="ulz-mod-action ulz-mod-action-{{ $type }}" data-type="{{ $type }}">
    <div class="ulz-action-button">

        @if( $enable_author )
            {{ Ucore()->the_template('single/action/author') }}
        @endif

        @if( ! empty( $title ) )
            <h5 class="ulz--title">{{ $title }}</h5>
        @endif

        @if( $meta )
            <div class="ulz-bullets">
                <ul>
                    @foreach( $meta as $m )

                        @php
                            $field_value = $listing->get( $m->fields->id );
                        @endphp

                        @if( $field_value )
                            <li>

                                @if( isset( $m->fields->icon[0] ) )
                                    {!! utillz_core()->icon->get( $m->fields->icon[0]->icon, $m->fields->icon[0]->set ) !!}
                                @endif

                                @switch( $m->fields->type )

                                    @case('address')
                                        <a href="{{ add_query_arg( [ 'api' => 1, 'query' => urlencode( $field_value ) ], 'https://www.google.com/maps/search/' ) }}" target="_blank">
                                            {{ str_replace( '{field}', $field_value, $m->fields->format ) }}
                                        </a>
                                        @break

                                    @case('url')
                                        <a href="{{ esc_url( str_replace( '{field}', $field_value, $m->fields->format ) ) }}" target="_blank">
                                            @if( isset( $m->fields->type_url_label ) && ! empty( $m->fields->type_url_label ) )
                                                {{ $m->fields->type_url_label }}
                                            @else
                                                {{ str_replace( '{field}', $field_value, $m->fields->format ) }}
                                            @endif
                                        </a>
                                        @break

                                    @case('phone')
                                        <a href="tel:{{ $field_value }}" target="_blank">
                                            {{ str_replace( '{field}', $field_value, $m->fields->format ) }}
                                        </a>
                                        @break

                                    @case('email')
                                        <a href="mailto:{{ $field_value }}" target="_blank">
                                            {{ str_replace( '{field}', $field_value, $m->fields->format ) }}
                                        </a>
                                        @break

                                    @case('price')
                                        <span>
                                            {!! str_replace( '{field}', Ucore()->format_price( $field_value ), $item->fields->format ) !!}
                                        </span>
                                        @break

                                    @default
                                        <span>
                                            {{ str_replace( '{field}', $field_value, $m->fields->format ) }}
                                        </span>

                                @endswitch

                            </li>
                        @endif

                    @endforeach
                </ul>
            </div>
        @endif

        @if( $show_button )
            <div class="ulz-action-footer">
                <div class="ulz--action">
                    <a href="{{ $url }}"
                        class="ulz-button ulz-button-accent ulz--large"
                        {{ $target }}
                        {!! $modal !!}>
                        <span>
                            {{ $button_label ? $button_label : $strings->label }}
                        </span>
                    </a>
                </div>
            </div>
        @endif

    </div>
</div>
