<?php

namespace UtillzCore\Inc\Src\Listing\Modules\Content;

use \UtillzCore\Inc\Src\Listing\Modules\Module;

class Content extends Module {

    public function controller() {

        switch( $this->props->id ) {
            case 'post_content': $content = get_post_field( 'post_content' ); break;
            case 'post_title': $content = get_post_field( 'post_title' ); break;
            default: $content = Ucore()->get( $this->props->id );
        }

        return array_merge( (array) $this->props, [
            'id' => $this->props->id,
            'name' => $this->props->name,
            'read_more' => isset( $this->props->read_more ) ? $this->props->read_more : false,
            'content' => $content,
            'strings' => (object) [
                'read_more' => esc_html__('Read more', 'utillz')
            ],
        ]);

    }

}
