<?php

namespace UtillzCore\Inc\Src\Submission\Modules\Pricing;

use \UtillzCore\Inc\Src\Submission\Submission;
use \UtillzCore\Inc\Src\Submission\Modules\Module;
use \UtillzCore\Inc\Src\Request\Custom_Request;
use \UtillzCore\Inc\Src\Form\Component as Form;
use \UtillzCore\Inc\Src\Validation;
use \UtillzCore\Inc\Src\Listing_Type\Action;

class Pricing extends Module {

    public function controller() {

        global $ulz_submission;

        $action_types = $ulz_submission->listing_type->get_action();
        $action_fields = Action::get_action_fields( $ulz_submission->listing_type );

        return [
            'form' => new Form( Form::Storage_Request ),
            'title' => esc_html__('Pricing', 'utillz-core'),
            'action_fields' => $action_fields,
            'allow_not_required_price' => $action_fields,
            'strings' => (object) [
                'price_base' => esc_html__('Base Price', 'utillz-core'),
                'end_date' => esc_html__('End Date', 'utillz-core' ),
                'extra_service_pricing' => esc_html__('Extra service pricing', 'utillz-core'),
                'add_extra_pricing' => esc_html__('Add extra service pricing', 'utillz-core'),
                'add_service' => esc_html__('Add service', 'utillz-core'),
                'service' => esc_html__('Service', 'utillz-core'),
                'service_name' => esc_html__('Service name', 'utillz-core'),
                'service_name_placeholder' => esc_html__('Enter service name', 'utillz-core'),
                'service_type' => esc_html__('Service type', 'utillz-core'),
                'service_price' => esc_html__('Service price', 'utillz-core'),
                'single_fee' => esc_html__('Single fee', 'utillz-core'),
                'add_addons' => esc_html__('Add addons', 'utillz-core'),
                'add_addon' => esc_html__('Add addon', 'utillz-core'),
                'addons' => esc_html__('Addons', 'utillz-core'),
                'addon' => esc_html__('Addon', 'utillz-core'),
                'addon_name' => esc_html__('Addon name', 'utillz-core'),
                'addon_id' => esc_html__('Addon id', 'utillz-core'),
                'enter_addon_name' => esc_html__('Enter addon name', 'utillz-core'),
                'addon_price' => esc_html__('Addon price', 'utillz-core'),
            ]
        ];

    }

    public function validation() {

        $request = new Custom_Request('input');
        $submission = new Submission( $request->get('type') );
        $validation = new Validation();

        $action_types = $submission->listing_type->get_action();
        $action_fields = Action::get_action_fields( $submission->listing_type );

        // pricing
        if( $action_fields->allow_pricing ) {

            $terms = [];

            if( boolval( ! $action_fields->allow_not_required_price ) ) {
                $terms['ulz_price'] = 'required';
            }

            $response = $validation->validate( $request->params, $terms );

            wp_send_json( $response );

        }

    }

}
