<?php

use \UtillzCore\Inc\Src\Listing\Views;
use \UtillzCore\Inc\Src\Wallet;

defined('ABSPATH') || exit;

// views
$today_views = Views::get_all_today_views();

// $yesterday_views = Views::get_all_today_views( null, date('Y-m-d', strtotime('-1 days') ) );
// $views_difference_percent = round( ( 1 - ( $today_views / $yesterday_views ) ) * 100 );

// earnings
$today_earnings = Wallet::get_earnings();

// waller
$wallet = new Wallet();
$payouts = $wallet->get_payouts();

$user = new \UtillzCore\Inc\Src\User( get_current_user_id() );
$user_data = $user->get_userdata();
$user_role = get_user_meta( get_current_user_id(), 'ulz_role', true );

/*
 * customer
 *
 */
if( empty( $user_role ) || $user_role == 'customer' ):
?>

<?php if( get_option('ulz_enable_dashboard_role') ): ?>
    <p class="ulz-weight-600 ulz-text-right">
        <a class="ulz-no-decoration" href="<?php echo esc_url( add_query_arg( 'ulz_switch_user_role', '', wc_get_account_endpoint_url( 'dashboard' ) ) ); ?>">
            <span><?php esc_html_e( 'Switch to business', 'utillz-core' ); ?></span>
            <i class="fas fa-arrow-right ulz-ml-1"></i>
        </a>
    </p>
<?php endif; ?>

<div class="ulz-dashboard">
    <div class="ulz-grid">
        <div class="ulz-col-8 ulz-col-xl-12">
            <div class="ulz-grid">
                <div class="ulz-col-6 ulz-col-xl-12">
                    <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-account' ) ); ?>" class="ulz--box">
                        <i class="material-icons">style</i>
                        <span class="ulz--title"><?php esc_html_e( 'Account details', 'utillz-core' ); ?><i class="fas fa-caret-right ulz-ml-1"></i></span>
                        <p class="ulz-mt-1 ulz-mb-0"><?php esc_html_e( 'Provide personal details and how we can reach you', 'utillz-core' ); ?></p>
                    </a>
                </div>
                <div class="ulz-col-6 ulz-col-xl-12">
                    <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'messages' ) ); ?>" class="ulz--box">
                        <i class="material-icons">chat</i>
                        <span class="ulz--title"><?php esc_html_e( 'Messages', 'utillz-core' ); ?><i class="fas fa-caret-right ulz-ml-1"></i></span>
                        <p class="ulz-mt-1 ulz-mb-0"><?php esc_html_e( 'Track all your important conversations with the world', 'utillz-core' ); ?></p>
                    </a>
                </div>
                <div class="ulz-col-6 ulz-col-xl-12">
                    <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'orders' ) ); ?>" class="ulz--box">
                        <i class="material-icons">library_add_check</i>
                        <span class="ulz--title"><?php esc_html_e( 'My orders', 'utillz-core' ); ?><i class="fas fa-caret-right ulz-ml-1"></i></span>
                        <p class="ulz-mt-1 ulz-mb-0"><?php esc_html_e( 'Get information about your orders, payments and details', 'utillz-core' ); ?></p>
                    </a>
                </div>
                <div class="ulz-col-6 ulz-col-xl-12">
                    <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'notification-settings' ) ); ?>" class="ulz--box">
                        <i class="material-icons">notifications_active</i>
                        <span class="ulz--title"><?php esc_html_e( 'Notification settings', 'utillz-core' ); ?><i class="fas fa-caret-right ulz-ml-1"></i></span>
                        <p class="ulz-mt-1 ulz-mb-0"><?php esc_html_e( 'Enable notifications for important actions and activities', 'utillz-core' ); ?></p>
                    </a>
                </div>
            </div>
        </div>
        <div class="ulz-col-4 ulz-col-xl-12 ulz-flex ulz-flex-column">
            <div class="ulz--box ulz-box-author ulz-text-center">
                <div class="ulz--avatar">
                    <?php $user_avatar = $user->get_avatar(); ?>
                    <?php if( $user_avatar ): ?>
                        <img src="<?php echo esc_url( $user_avatar ); ?>" alt="">
                    <?php else: ?>
                        <i class="material-icons">person</i>
                    <?php endif; ?>
                </div>
                <p class="ulz-mb-0"><?php esc_html_e( 'Hello', 'utillz-core' ); ?></p>
                <span class="ulz--title"><?php echo esc_html( $user_data->display_name ); ?>!</span>
                <p><?php echo esc_html( wp_trim_words( $user_data->description, 20 ) ); ?></p>
                <div class="ulz-mt-auto">
                    <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-account' ) ); ?>" class="ulz-button">
                        <?php esc_html_e( 'Edit account details', 'utillz-core' ); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

</div>

<?php
/*
 * business
 *
 */
else:
?>

<?php if( get_option('ulz_enable_dashboard_role') ): ?>
    <p class="ulz-weight-600 ulz-text-right">
        <a class="ulz-no-decoration" href="<?php echo apply_filters( 'utillz/account/dashboard/switch-user-role', esc_url( add_query_arg( 'ulz_switch_user_role', '', wc_get_account_endpoint_url( 'dashboard' ) ) ) ); ?>" data-action="account-switch-user-role">
            <span><?php esc_html_e( 'Switch to customer', 'utillz-core' ); ?></span>
            <i class="fas fa-arrow-right ulz-ml-1"></i>
        </a>
    </p>
<?php endif; ?>

<div class="ulz-dashboard">
    <div class="ulz-grid ulz-dashboard-row">
        <div class="ulz-col-4 ulz-col-xl-12">
            <div class="ulz--box ulz--has-icon">
                <i class="material-icons">remove_red_eye</i>
                <span class="ulz--title"><?php esc_html_e( 'Views today', 'utillz-core' ); ?></span>
                <span class="ulz--num ulz-font-heading"><?php echo Ucore()->short_number( $today_views ); ?></span>
            </div>
        </div>
        <div class="ulz-col-4 ulz-col-xl-12">
            <div class="ulz--box ulz--has-icon">
                <i class="material-icons">timeline</i>
                <span class="ulz--title"><?php esc_html_e( 'Today earnings', 'utillz-core' ); ?></span>
                <span class="ulz--num ulz-font-heading"><?php echo Ucore()->format_price( $today_earnings ); ?></span>
            </div>
        </div>
        <div class="ulz-col-4 ulz-col-xl-12">
            <div class="ulz--box ulz--highlight ulz--has-icon">
                <i class="material-icons">account_balance_wallet</i>
                <span class="ulz--title"><?php esc_html_e( 'Your balance', 'utillz-core' ); ?></span>
                <span class="ulz--num ulz-font-heading"><?php echo Ucore()->format_price( $wallet->get_balance() ); ?></span>
            </div>
        </div>
    </div>

    <div class="ulz-grid ulz-dashboard-row">
        <div class="ulz-col-12">
            <div class="ulz--box">
                <div class="ulz-flex">
                    <div class="">
                        <span class="ulz--title ulz-mb-0 ulz-mr-1"><?php esc_html_e( 'Latest views', 'utillz-core' ); ?></span>
                    </div>
                    <div class="ulz-ml-auto">
                        <!-- .. -->
                    </div>
                </div>
                <div class="ulz-chart" data-id="dashboard">
                    <div id="ulz-chart-render"></div>
                    <?php Ucore()->preloader(); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="ulz-grid">
        <div class="ulz-col-4 ulz-col-xl-12">
            <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'listings' ) ); ?>" class="ulz--box">
                <i class="material-icons">place</i>
                <span class="ulz--title"><?php esc_html_e( 'Listings', 'utillz-core' ); ?><i class="fas fa-caret-right ulz-ml-1"></i></span>
                <p class="ulz-mt-1 ulz-mb-0"><?php esc_html_e( 'Manage all your listings and track important information', 'utillz-core' ); ?></p>
            </a>
        </div>
        <div class="ulz-col-4 ulz-col-xl-12">
            <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'entries' ) ); ?>" class="ulz--box">
                <i class="material-icons">add_circle</i>
                <span class="ulz--title"><?php esc_html_e( 'Entries', 'utillz-core' ); ?><i class="fas fa-caret-right ulz-ml-1"></i></span>
                <p class="ulz-mt-1 ulz-mb-0"><?php esc_html_e( 'Manage your incoming and outgoing entries', 'utillz-core' ); ?></p>
            </a>
        </div>
        <div class="ulz-col-4 ulz-col-xl-12">
            <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'messages' ) ); ?>" class="ulz--box">
                <i class="material-icons">chat</i>
                <span class="ulz--title"><?php esc_html_e( 'Messages', 'utillz-core' ); ?><i class="fas fa-caret-right ulz-ml-1"></i></span>
                <p class="ulz-mt-1 ulz-mb-0"><?php esc_html_e( 'Track all your important conversations with the world', 'utillz-core' ); ?></p>
            </a>
        </div>
    </div>

</div>

<?php endif; ?>
