<?php

use \UtillzCore\Inc\Src\Listing\Conversation;

defined('ABSPATH') || exit;

global $ulz_listing;

if( ! $ulz_listing->id ) {
    return;
}

$status = get_post_status( get_the_ID() );
$entry_type = Ucore()->get('ulz_entry_type');

$conversation_id = null;
$request_user_id = Ucore()->get('ulz_request_user_id');

if( $ulz_listing->id ) {
    $current_user_id = get_current_user_id();
    $reciever_id = ( $request_user_id == $current_user_id ) ? $ulz_listing->post->post_author : $current_user_id;
    $conversation_id = Conversation::get_or_create_by_user_id( $ulz_listing->id, $request_user_id, $reciever_id );
}

if( $ulz_listing->type ) {
    $review_submission = $ulz_listing->type->get('ulz_review_submission');
    if( empty( $review_submission ) ) {
        $review_submission = 'everyone';
    }
}

?>

<div class="ulz--actions">
    <div class="ulz--primary-actions">
        <ul>
            <?php if( $entry_type == 'purchase' || $entry_type == 'application' ): ?>
                <li>
                    <a href="#" data-modal="entry-edit" data-params='{"id":<?php the_ID(); ?>}'>
                        <i class="material-icons">mode_edit</i>
                    </a>
                </li>
            <?php endif; ?>
            <?php if( $status == 'publish' && ( $review_submission == 'engaged' || $review_submission == 'everyone' ) && $request_user_id == get_current_user_id() ): ?>
                <li>
                    <a href="#" data-modal="review-submit" data-params='<?php echo (int) $ulz_listing->id; ?>'>
                        <i class="material-icons">grade</i>
                    </a>
                </li>
            <?php endif; ?>
            <?php if( (int) $conversation_id > 0 ): ?>
                <li>
                    <a href="#" class="ulz--toggle-active" data-modal="conversation" data-params='{"id":<?php echo (int) $conversation_id; ?>}'>
                        <i class="material-icons">send</i>
                    </a>
                </li>
            <?php endif; ?>
        </ul>
    </div>
</div>
