<?php

use \UtillzCore\Inc\Src\Listing\Conversation;
use \UtillzCore\Inc\Src\Request\Request;

defined('ABSPATH') || exit;

$conversations = Conversation::get_conversations();
$request = Request::instance();
$page = $request->has('onpage') ? $request->get('onpage') : 1;

?>

<?php if( $conversations->have_posts() ): ?>
    <div class="ulz-boxes-table">
        <div class="ulz--inner">
            <table>
                <tbody>
                    <?php while( $conversations->have_posts() ) : $conversations->the_post(); ?>
                        <?php Ucore()->the_template('account/messages/row'); ?>
                    <?php endwhile; wp_reset_postdata(); ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="ulz-paging">
        <?php
            echo Ucore()->pagination([
                'base' => add_query_arg( [ 'onpage' => '%#%' ], wc_get_account_endpoint_url( 'messages' ) ),
                'format' => '?onpage=%#%',
                'current' => $page,
                'total' => $conversations->max_num_pages,
            ]);
        ?>
    </div>
<?php else: ?>
    <p><?php esc_html_e( 'No conversations were found', 'utillz-core' ); ?></p>
<?php endif; ?>
