<?php

defined('ABSPATH') || exit;

class Panel {
    private $form;

    public function getForm() {
        return $this->form;
    }
}

// In your code
$panel = \UtillzCore\Inc\Src\Admin\Panel::instance();
$form = $panel->getForm();
$listing = new \UtillzCore\Inc\Src\Listing\Listing( get_the_ID() );

?>

<div class="ulz-panel ulz-outer">
    <div class="ulz-meta-side">
        <div class="ulz-form">

            <?php

                $promoted_expiration = (int) Ucore()->get( 'ulz_promotion_expires' );
                if( $promoted_expiration /*&& $promoted_expiration > time()*/ ) {
                    echo '<div class="ulz-notice ulz-mb-2"><p class="ulz-promotion-expires">' . sprintf( __( 'Promoted listing, expires:<br>%s', 'utillz-core' ), date_i18n( get_option('date_format') . ' ' . get_option('time_format'), $promoted_expiration ) ) . '</p></div>';
                }

            ?>

            <div class="ulz-grid">

                <?php

                    // priority
                    $priority = (int) $listing->get('ulz_priority');

                    switch( true ) {
                        case $priority == 0 : $priority_selection_value = 'normal'; break;
                        case $priority == 1 : $priority_selection_value = 'featured'; break;
                        case $priority == 2 : $priority_selection_value = 'promoted'; break;
                        case $priority >= 3 : $priority_selection_value = 'custom'; break;
                    }

                    $form->render([
                        'type' => 'radio',
                        'id' => 'priority_selection',
                        'name' => __( 'Listing priority', 'utillz-core' ),
                        'description' => __( 'Set what priority will be given to this listing in search results.', 'utillz-core' ),
                        'options' => [
                            'normal' => esc_html__( 'Normal', 'utillz-core' ),
                            'featured' => esc_html__( 'Featured', 'utillz-core' ),
                            'promoted' => esc_html__( 'Promoted', 'utillz-core' ),
                            'custom' => esc_html__( 'Custom', 'utillz-core' ),
                        ],
                        'value' => $priority_selection_value
                    ]);

                    $form->render([
                        'type' => 'number',
                        'id' => 'priority_custom',
                        'description' => __( 'Higher value means higher priority in search results.<br><br>Normal = 0<br>Featured = 1<br>Promoted = 2', 'utillz-core' ),
                        'min' => 0,
                        'max' => 100,
                        'dependency' => [
                            'id' => 'priority_selection',
                            'value' => 'custom',
                            'compare' => '=',
                        ],
                        'value' => $priority,
                    ]);

                    // expiration
                    $listing_expires = Ucore()->get('ulz_listing_expires');

                    $form->render([
                        'type' => 'checkbox',
                        'id' => 'enable_listing_expiration',
                        'name' => __( 'Enable listing expiration', 'utillz-core' ),
                        'value' => boolval( $listing_expires )
                    ]);

                    $form->render([
                        'type' => 'datetime',
                        'id' => 'listing_expiration',
                        'dependency' => [
                            'id' => 'enable_listing_expiration',
                            'compare' => '=',
                            'value' => true,
                        ],
                        'value' => strtotime( $listing_expires )
                    ]);

                    $form->render([
                        'type' => 'hidden',
                        'id' => 'remove_listing_expiration',
                        'value' => true
                    ]);

                ?>

            </div>
        </div>
    </div>
</div>
