<?php

defined('ABSPATH') || exit;

global $ulz_listing;

$gallery = $ulz_listing->get_gallery( apply_filters('utillz/explore/listing/gallery/size', 'ulz_listing') );
$cover_type = $ulz_listing->type->get('ulz_listing_cover_type');

?>

<div class="ulz-listing-image">
    <?php if( isset( $gallery[0] ) ): ?>
        <a href="<?php echo get_permalink(); ?>" class="ulz-image" style="background-image:url('<?php echo esc_url( $gallery[0] ); ?>');" <?php Ucore()->set_explore_open(); ?>></a>
        <?php if( count( $gallery ) > 1 && $cover_type == 'slider' ): ?>
            <div class="ulz-listing-gallery">
                <?php foreach( $gallery as $key => $image ): ?>
                    <?php
                        $style = '';
                        if( $key == 0 ) {
                            $style = 'opacity:1;background-image:url(\'' . esc_url( $image ) . '\');';
                        }
                    ?>
                    <a href="<?php echo get_permalink(); ?>" class="ulz-listing-gallery-item" style="<?php echo $style; ?>" <?php if( $key > 0 ) { echo sprintf( 'data-image="%s"', esc_url( $image ) ); } ?> <?php Ucore()->set_explore_open(); ?>></a>
                <?php endforeach; ?>
            </div>
            <a href="#" class="ulz-slider-nav ulz-nav-prev"><span><i class="material-icons">arrow_back</i></span></a>
            <a href="#" class="ulz-slider-nav ulz-nav-next"><span><i class="material-icons">arrow_forward</i></span></a>
        <?php endif; ?>
    <?php else: ?>
        <a href="<?php echo get_permalink(); ?>" <?php Ucore()->set_explore_open(); ?>>
            <?php echo Ucore()->dummy('far fa-image', 'font-awesome'); ?>
        </a>
    <?php endif; ?>
</div>
