<?php

use \UtillzCore\Inc\Src\User;
use \UtillzCore\Inc\Src\Listing\Listing;
use \UtillzCore\Inc\Src\Form\Component as Form;

defined('ABSPATH') || exit;

global $post;

$form = new Form( Form::Storage_Field );
$user = User::instance();
$listing = new Listing( $post->ID );
$has_reported = $listing->has_reported();

$action_type = $listing->type->get_action_type('report');
$report_fields = [];

if( $action_type && $action_type->fields->fields ) {
    foreach( $action_type->fields->fields as $field ) {
        $report_fields[ $field->fields->key ] = $field->fields->name;
    }
}

?>

<div class="ulz-modal ulz-modal-action-report" data-id="action-report">
    <?php Ucore()->the_template('modals/close'); ?>
    <div class="ulz-modal-heading ulz--border">
        <h4 class="ulz--title"><?php esc_html_e( 'Send listing report', 'utillz-core' ); ?></h4>
    </div>
    <div class="ulz-modal-content">
        <div class="ulz-modal-append">
            <div class="ulz-modal-container ulz-scrollbar">

                <?php if( (int) $listing->post->post_author == $user->id ): ?>

                    <div class="ulz-reported">
                        <div class="ulz--icon">
                            <i class="material-icons">highlight_off</i>
                            <p><?php esc_html_e( 'You can\'t report your own listing', 'utillz-core' ); ?></p>
                        </div>
                    </div>

                <?php else: ?>

                    <div class="ulz-reported <?php if( ! $has_reported ) { echo 'ulz-none'; } ?>">
                        <div class="ulz--icon">
                            <i class="material-icons">highlight_off</i>
                            <p><?php esc_html_e( 'You already reported this listing', 'utillz-core' ); ?></p>
                        </div>
                    </div>

                    <?php if( ! $has_reported ): ?>
                        <div class="ulz-report-submit">
                            <p><?php esc_html_e( 'The report is private and won\'t be shared with the owner', 'utillz-core' ); ?></p>
                            <div class="ulz-form">
                                <?php wp_nonce_field( 'utillz_report_nonce', 'utillz_report' ); ?>
                                <div class="ulz-grid">
                                    <?php

                                        $form->render([
                                            'type' => 'radio',
                                            'id' => 'ulz_report_reason',
                                            'options' => $report_fields,
                                            'class' => ['ulz-mb-0']
                                        ]);

                                    ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <?php if( (int) $listing->post->post_author !== $user->id && ! $has_reported ): ?>
                <div class="ulz-modal-footer ulz--top-border ulz-text-center">
                    <a href="#" id="ulz-send-report" class="ulz-button ulz-button-accent ulz-modal-button">
                        <span><?php esc_html_e( 'Send Report', 'utillz-core' ); ?></span>
                        <?php Ucore()->preloader(); ?>
                    </a>
                </div>
            <?php endif; ?>
        </div>
        <?php Ucore()->preloader(); ?>
    </div>
</div>
