<?php

global $ulz_listing, $ulz_nearby_post_ids;
$ulz_listing = new \UtillzCore\Inc\Src\Listing\Listing( get_the_ID() );

if( ! $ulz_listing->type ) {
    return;
}

if( $ulz_listing->type->get('ulz_enable_related') ):

    $related = new UtillzCore\Inc\Src\Listing\Related( $ulz_listing->id );
    $related->set_posts_per_page( $ulz_listing->type->get('ulz_related_posts_per_page') );
    $listings = $related->query();

    ?>

    <div class="ulz-mod-listing">
        <div class="ulz-mod-content">
            <h4><?php esc_html_e( 'Related', 'utillz-core' ); ?></h4>
            <?php if( $listings->have_posts() ): ?>
                <div class="ulz-listings-outer">
                    <ul class="ulz-listings" data-cols="3">
                        <?php while ( $listings->have_posts() ): $listings->the_post(); ?>
                            <li class="ulz-listing-item <?php Ucore()->listing_class(); ?>">
                                <?php Ucore()->the_template('explore/listing/listing'); ?>
                            </li>
                        <?php endwhile; wp_reset_postdata(); ?>
                    </ul>
                </div>
            <?php else: ?>
                <p class="ulz-mb-0"><?php esc_html_e( 'No related items were found', 'utillz-core' ); ?></p>
            <?php endif; ?>
        </div>
    </div>

<?php endif; ?>
