<?php

use \UtillzCore\Inc\Src\Request\Request;

defined('ABSPATH') || exit;

global $ulz_listing;

$request = Request::instance();

$page = max( 1, $request->get('onpage') );
$comments_per_page = $ulz_listing->type->get('ulz_reviews_per_page');

$comment_query = new \WP_Comment_Query;
$comments = $comment_query->query([
    'post_id' => $ulz_listing->id,
    'status' => 'approve',
    'parent' => 0,
    'hierarchical' => false,
    'orderby' => 'comment_date',
    'order' => 'DESC',
    'number' => $comments_per_page,
    'offset' => ( $page - 1 ) * $comments_per_page,
    'paged' => $page
]);

if( ! $comments ) {
    return;
}

?>

<ul class="ulz-comments">
    <?php foreach( $comments as $comment ): ?>
        <?php

            $user = new \UtillzCore\Inc\Src\User( $comment->user_id );
            $userdata = $user->get_userdata();
            $is_content_large = str_word_count( $comment->comment_content ) > 40;
            $average = get_comment_meta( $comment->comment_ID, 'ulz_rating_average', true );
            $media = Ucore()->json_decode( get_comment_meta( $comment->comment_ID, 'ulz_gallery', true ) );

        ?>
        <li data-id="<?php echo (int) $comment->comment_ID; ?>">
            <div class="ulz-comment-content">
                <div class="ulz-comment-heading">
                    <div class="ulz-comment-image">
                        <?php echo $user->avatar(); ?>
                    </div>
                    <div class="ulz-comment-meta ulz-flex ulz-flex-column ulz-justify-center">

                        <div class="ulz-grid ulz-justify-space">
                            <div class="ulz-col-auto">
                                <div class="ulz-comment-user">
                                    <?php if( isset( $userdata->display_name ) ): ?>
                                        <span class="ulz-comment-name ulz-font-heading">
                                            <?php echo $userdata->display_name; ?>
                                        </span>
                                    <?php endif; ?>
                                    <?php if( $average ): ?>
                                        <span class="ulz-comment-rating">
                                            <i class="fas fa-star"></i>
                                            <strong><?php echo number_format( floatval( $average ), 2 ); ?></strong>
                                        </span>
                                    <?php endif; ?>
                                </div>
                                <div class="ulz-comment-date">
                                    <?php echo esc_html( date_i18n( get_option( 'date_format' ), strtotime( $comment->comment_date ) ) ); ?>
                                </div>
                            </div>
                            <?php if( is_user_logged_in() && $ulz_listing->post->post_author == get_current_user_id() ): ?>
                                <div class="ulz-col-auto ulz-flex ulz-flex-column ulz-justify-center">
                                    <div class="ulz-comments-reply ulz-text-right">
                                        <a href="#" class="ulz-button ulz-tiny ulz-lighter" data-modal="review-reply" data-params="<?php echo (int) $comment->comment_ID; ?>">
                                            <?php esc_html_e( 'Reply', 'utillz-core' ); ?>
                                        </a>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
                <div class="ulz-comment-text" data-id="<?php echo (int) $comment->comment_ID; ?>">
                    <?php echo wpautop( wp_kses( $comment->comment_content, Ucore()->allowed_html() ) ); ?>
                    <?php if( is_array( $media ) && ! empty( $media ) ): ?>
                        <div class="ulz-comment-media">
                            <ul class="ulz-gallery-stack">
                                <?php foreach( $media as $image ): ?>
                                    <?php $image_src = wp_get_attachment_image_src( $image->id, 'thumbnail' ); ?>
                                    <?php if( isset( $image_src[0] ) ): ?>
                                        <?php $image_src_large = wp_get_attachment_image_src( $image->id, 'ulz_gallery_large' ); ?>
                                        <li class="ulz-gallery" data-image="<?php echo esc_url( $image_src_large[0] ); ?>">
                                            <a href="#">
                                                <img src="<?php echo esc_url( $image_src[0] ); ?>" alt="">
                                            </a>
                                        </li>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <?php

                        $children = get_comments([
                            'status' => 'approve',
                            'order' => 'DESC',
                            'parent' => $comment->comment_ID,
                        ]);

                        if( $children ) {
                            foreach( $children as $child ) {
                                echo '<div class="ulz-comment-child"><p class="ulz--author ulz-font-heading">' . ( ( $child->user_id == $ulz_listing->post->post_author ) ? esc_html( get_the_author_meta('display_name', $ulz_listing->post->post_author ) ) : esc_attr( $child->comment_author ) ) . '</p>' . wpautop( $child->comment_content ) . '</div>';
                            }
                        }

                    ?>
                </div>
            </div>
        </li>
    <?php endforeach; ?>
</ul>
