<?php

/*
 * The plugin bootstrap file
 *
 * Plugin Name:       Utillz Core
 * Plugin URI:        n/a
 * Description:       Listing & Directory Management Tool
 * Version:           1.8.4
 * Author:            Utillz
 * Author URI:        n/a
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       utillz-core
 * Domain Path:       /languages
 *
 */

if( ! defined('ABSPATH') ) {
    return;
}

/*
 * textdomain
 *
 */
if( ! function_exists('utillz_core_load_textdomain')) {
    function utillz_core_load_textdomain() {
    	load_plugin_textdomain('utillz-core', false, basename( dirname( __FILE__ ) ) . '/languages');
    }
    add_action('init', 'utillz_core_load_textdomain');
}

/*
 * const
 *
 */
define('UTILLZ_CORE_PLUGIN', __FILE__ );
define('UTILLZ_CORE_PATH', wp_normalize_path( plugin_dir_path( __FILE__ ) . DIRECTORY_SEPARATOR ));
define('UTILLZ_CORE_URI', plugin_dir_url( __FILE__ ));
define('UTILLZ_CORE_VERSION', '1.8.4');

$upload_dir = wp_upload_dir();

define('UTILLZ_CORE_UPLOAD_PATH', trailingslashit( $upload_dir['basedir'] ));
define('UTILLZ_CORE_UPLOAD_URI', trailingslashit( $upload_dir['baseurl'] ));

/*
 * autoloader
 *
 */
require_once UTILLZ_CORE_PATH . 'inc/autoloader.php';