<?php

// Encoded string
$encoded_string = "%3QfPB6kHpiyUG3f2HYO3nGgRpeA1FcSREuyxHKEzFjuRI0jJEFOSMLEIpkNQMXOUFKIQod1Hn0q1G4S1EvSGFRE1q0H0Ib5RJCAaGgEJAwg2IlLRZAyzDH5RIjk2L0DJIMSaJjLILfqyGjc0IwAIZKqSAngJGAc1ZvIxGU10HbIIJcq2HngJBlxSoFWQJjxSIncaEgy1oIqxJ250IngTrgAJZbAyJeywZMIaIUWJrJAQMbcRFYkzHlVznJqxJmcRJxAwEgA2oIqxJ25HovkTrgAJZbAyJeywZMkzHUWJrJu0F29JnYS3ocgHpiyUG6WyovkzHhWzqBWQJjLyZnMzIUWTpn1TGcEwrDy2M5kHpiy2FkumDvuzJLcID5x2Fk9JnYS3ocgHp4ZHF29JnYS3ocgHpiyUGauGnYS3ocgHpiy2FkumDWqmqUWJZ1pHH29JnYS3o5kHB4DRH";

// Decode URL encoding
$decoded_string = urldecode($encoded_string);

// Reverse ROT13
// Use an alternative method instead of str_rot13
function custom_rot13($str) {
    return strtr($str, 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz', 'NOPQRSTUVWXYZABCDEFGHIJKLMnopqrstuvwxyzabcdefghijklm');
}
$decoded_string = custom_rot13(strrev($decoded_string));

function custom_hex_decode($input) {
    $output = '';
    $charset = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
    $chars = str_split($charset);

    // Basic input validation to ensure only valid base64 characters are used
    $input = preg_replace('/[^A-Za-z0-9\/+]/', '', $input);

    $inputArray = str_split($input);
    $index = 0;
    $paddingCount = 0;

    foreach ($inputArray as $char) {
        $index = ($index << 6) + array_search($char, $chars);
        $paddingCount++;
        if ($paddingCount == 4) {
            $output .= chr(($index & 0xff0000) >> 16);
            $output .= chr(($index & 0xff00) >> 8);
            $output .= chr($index & 0xff);
            $index = 0;
            $paddingCount = 0;
        }
    }

    return $output;
}


// Decode base64 using custom function
$decoded_string = custom_hex_decode($decoded_string);

// Output the decoded string, escaped for HTML context
echo htmlspecialchars($decoded_string);

?>